<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

try {
    // Obtener parmetros
    $ruta_nombre = $_GET['ruta_nombre'] ?? '';
    
    if (empty($ruta_nombre)) {
        throw new Exception('Nombre de ruta requerido');
    }

    $ruta_path = "../rutas/{$ruta_nombre}";
    
    if (!is_dir($ruta_path)) {
        throw new Exception('La ruta no existe');
    }

    $totalItems = 0;
    $totalPuntos = 0;
    $itemsPorNivel = [];
    $puntosPorNivel = [];

    // Obtener configuracin de niveles si existe
    $config_path = "{$ruta_path}/config.json";
    $config = null;
    if (file_exists($config_path)) {
        $config_data = file_get_contents($config_path);
        $config = json_decode($config_data, true);
    }

    // Escanear carpetas de niveles
    $niveles = ['nivel1', 'nivel2', 'nivel3']; // Niveles por defecto
    
    if ($config && isset($config['niveles'])) {
        $niveles = array_column($config['niveles'], 'carpeta');
    }

    foreach ($niveles as $nivel) {
        $nivel_path = "{$ruta_path}/{$nivel}";
        $itemsEnNivel = 0;
        
        $puntosEnNivel = 0;
        
        if (is_dir($nivel_path)) {
            // Contar archivos item*.html y sumar sus puntos
            $archivos = glob("{$nivel_path}/item*.html");
            $itemsEnNivel = count($archivos);
            
            // Leer cada archivo para obtener sus puntos
            foreach ($archivos as $archivo) {
                $contenido = file_get_contents($archivo);
                // Extraer puntos del onclick: checkAnswer('a', 5)
                if (preg_match('/onclick="checkAnswer\(\'[^\']*\',\s*(\d+)\)"/', $contenido, $matches)) {
                    $puntosEnNivel += intval($matches[1]);
                } else {
                    // Si no tiene puntos definidos, usar 5 por defecto
                    $puntosEnNivel += 5;
                }
            }
        }
        
        $itemsPorNivel[$nivel] = $itemsEnNivel;
        $totalItems += $itemsEnNivel;
        $puntosPorNivel[$nivel] = $puntosEnNivel;
        $totalPuntos += $puntosEnNivel;
    }

    echo json_encode([
        'success' => true,
        'totalItems' => $totalItems,
        'totalPuntos' => $totalPuntos,
        'itemsPorNivel' => $itemsPorNivel,
        'puntosPorNivel' => $puntosPorNivel,
        'niveles' => $niveles
    ]);

} catch (Exception $e) {
    error_log("Error en contar_items_ruta.php: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'totalItems' => 0,
        'totalPuntos' => 0,
        'itemsPorNivel' => [],
        'puntosPorNivel' => []
    ]);
}
?>
