<?php
session_start();
header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'details' => []];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    $ruta_nombre = $input['ruta_nombre'] ?? null;
    $nivel_carpeta = $input['nivel_carpeta'] ?? null;
    $numero_item = $input['numero_item'] ?? null;

    // Validaciones básicas
    if (!$ruta_nombre || !$nivel_carpeta || !$numero_item) {
        $response['message'] = 'Parámetros incompletos.';
        echo json_encode($response);
        exit;
    }

    // Construir ruta del archivo
    $ruta_carpeta = "../rutas/{$ruta_nombre}/{$nivel_carpeta}";
    $numero_padded = str_pad($numero_item, 2, '0', STR_PAD_LEFT);
    $archivo_item = "{$ruta_carpeta}/item{$numero_padded}.html";
    
    try {
        // Verificar si el archivo existe
        if (!file_exists($archivo_item)) {
            $response['message'] = "El archivo del item no existe.";
            echo json_encode($response);
            exit;
        }

        // Eliminar archivo
        if (unlink($archivo_item)) {
            $response['success'] = true;
            $response['message'] = "✅ Item {$numero_item} eliminado exitosamente de {$nivel_carpeta}";
            $response['details']['archivo_eliminado'] = $archivo_item;
        } else {
            $response['message'] = "Error al eliminar el archivo del item.";
        }

    } catch (Exception $e) {
        $response['message'] = "Error al eliminar el item: " . $e->getMessage();
        error_log("Error en eliminar_item.php: " . $e->getMessage());
    }
} else {
    $response['message'] = 'Método no permitido.';
}

echo json_encode($response);
?>
