<?php
header('Content-Type: application/json');

require_once '../config.php';
require_once '../conexion.php';

try {
    // Obtener parámetros
    $curso = isset($_GET['curso']) ? $_GET['curso'] : '';
    $unidad = isset($_GET['unidad']) ? $_GET['unidad'] : '';
    
    if (empty($curso) || empty($unidad)) {
        throw new Exception('Parámetros curso y unidad son requeridos');
    }
    
    // Construir el nombre de la tabla
    $nombre_tabla = 'avance_' . $curso . '_u' . str_pad($unidad, 2, '0', STR_PAD_LEFT);
    
    // Verificar que la tabla existe
    $stmt = $dsn->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = :tabla");
    $stmt->bindParam(':tabla', $nombre_tabla, PDO::PARAM_STR);
    $stmt->execute();
    $existe = $stmt->fetchColumn();
    
    if (!$existe) {
        throw new Exception('La tabla no existe');
    }
    
    // Obtener las columnas de la tabla con comentarios
    $sql = "SELECT 
                COLUMN_NAME as 'Field',
                COLUMN_TYPE as 'Type',
                IS_NULLABLE as 'Null',
                COLUMN_KEY as 'Key',
                COLUMN_DEFAULT as 'Default',
                EXTRA as 'Extra',
                COLUMN_COMMENT as 'Comment'
            FROM INFORMATION_SCHEMA.COLUMNS 
            WHERE TABLE_SCHEMA = DATABASE() 
            AND TABLE_NAME = :tabla 
            ORDER BY ORDINAL_POSITION";
    
    $stmt = $dsn->prepare($sql);
    $stmt->bindParam(':tabla', $nombre_tabla, PDO::PARAM_STR);
    $stmt->execute();
    $todas_variables = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Filtrar solo las variables que son TINYINT(1) (variables booleanas 0 o 1)
    $variables = array_filter($todas_variables, function($variable) {
        // Buscar variables que sean TINYINT(1), BOOL, BOOLEAN, o INT(1) con comentarios que indiquen 0/1
        $tipo = strtoupper($variable['Type']);
        
        // Patrones que indican variables booleanas
        return (
            preg_match('/TINYINT\(1\)/', $tipo) ||
            preg_match('/^TINYINT$/', $tipo) ||
            preg_match('/BOOL/', $tipo) ||
            preg_match('/INT\(1\)/', $tipo)
        );
    });
    
    // Reindexar el array
    $variables = array_values($variables);
    
    echo json_encode([
        'success' => true,
        'variables' => $variables
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
