# Generador de Archivos - Ruta Formativa CCBB

## 📁 Estructura del Proyecto

Este directorio contiene las herramientas para generar y gestionar los archivos de la plataforma Ruta Formativa CCBB.

### 🗂️ Archivos Incluidos

#### **Herramientas Principales**
- **`ayuda.php`** - Checklist principal con verificación automática de archivos
- **`ayuda.css`** - Estilos específicos para la página de ayuda

#### **Generadores**
- **`crear_index.html`** - Generador de `index.html`, `general.css` e `index.css`
- **`crear_login.html`** - Generador de sistema de login completo

#### **Scripts de Soporte**
- **`guardar_index.php`** - Guarda el archivo `index.html` en el directorio padre
- **`guardar_general_css.php`** - Guarda el archivo `general.css` en el directorio padre
- **`guardar_index_css.php`** - Guarda el archivo `index.css` en el directorio padre

## 🚀 Funcionalidades

### **Checklist Automático**
- Verifica la existencia de todos los archivos del proyecto
- Muestra estado visual (✅ existente, ❌ faltante)
- Progreso general del desarrollo
- Botones de generación directa para archivos faltantes

### **Generadores Inteligentes**
- **Generador de Index**: Crea `index.html`, `general.css` e `index.css`
- **Generador de Login**: Crea sistema completo de autenticación
- Interfaz visual intuitiva
- Previsualización en tiempo real
- Opciones de descarga y copia

### **Gestión de Archivos**
- Verificación automática de archivos existentes
- Generación de archivos faltantes
- Enlaces directos a archivos generados
- Navegación entre herramientas

## 📋 Organización por Fases

### **Fase 1: Página Principal**
- `index.html` - Página principal
- `general.css` - Estilos generales
- `index.css` - Estilos específicos

### **Fase 2: Sistema de Login**
- `login.html` - Página de login
- `login.css` - Estilos del login
- `config.php` - Configuración de BD
- `conexion.php` - Conexión a BD
- `login.php` - Procesamiento de login
- `session_start.php` - Gestión de sesiones

### **Fase 3: Panel Principal**
- `menu.php` - Panel principal
- `menu.css` - Estilos del panel
- `header.css` - Estilos del encabezado

### **Fase 4: Generadores**
- `crear_index.html` - Generador de index
- `crear_login.html` - Generador de login
- `guardar_index.php` - Script de guardado

### **Fase 5: Utilidades**
- `ayuda.php` - Esta página de ayuda
- `logout.php` - Cierre de sesión

## 🔧 Uso

### **Acceso Principal**
1. Navegar a `generador_de_archivos/ayuda.php`
2. Verificar estado de archivos
3. Usar generadores según necesidad

### **Generar Archivos**
1. Hacer clic en "Generar" para archivos faltantes
2. Usar generadores específicos para personalización
3. Descargar o copiar archivos generados

### **Navegación**
- **Volver al Menú**: Regresa al menú principal
- **Ver Web**: Abre archivos generados en el navegador
- **Generar**: Crea archivos faltantes automáticamente

## 📝 Notas Técnicas

### **Rutas Relativas**
- Los archivos generados se guardan en el directorio padre (`../`)
- Las referencias CSS apuntan a archivos en el directorio padre
- Los enlaces de verificación usan rutas relativas correctas

### **Compatibilidad**
- Funciona con servidores PHP
- Requiere permisos de escritura en directorio padre
- Compatible con navegadores modernos

## 🎯 Beneficios

- **Organización clara**: Separación de herramientas y archivos generados
- **Mantenimiento fácil**: Herramientas centralizadas
- **Desarrollo eficiente**: Generación automática de archivos
- **Control de calidad**: Verificación automática de integridad

---

**Desarrollado para la Ruta Formativa CCBB - INACAP** 