<?php
/**
 * Guarda el archivo menu.php generado
 */

// Obtener el título dinámicamente
$titulo = isset($_POST['titulo']) ? $_POST['titulo'] : 'INTRODUCCIÓN A LOS NÚMEROS COMPLEJOS';

// Si no se envía contenido, generar contenido básico
if (!isset($_POST['phpContent']) || empty($_POST['phpContent'])) {
    $phpContent = '<?php
include "session_start.php";
include "conexion.php";
include "leer_rol.php";
include "configuracion_cursos.php";
include "lectura_inscripcion_cursos.php";

if (!isset($_SESSION["rol"])) {
    $_SESSION["rol"] = 0;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Menú de Cursos</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet"/>
  <link rel="stylesheet" href="menu.css" />
  <link rel="stylesheet" href="header.css" />
  <link rel="stylesheet" href="general.css" />
</head>
<body>
  <header class="main-header">
    <div class="header-title gradient-text">' . $titulo . '</div>
    <div class="session-controls">
      <a href="logout.php" class="boton-rojo">Cerrar Sesión</a>
    </div>
  </header>

  <div class="welcome-section">
    <h1>Bienvenido(a), <span id="user-name"><?php echo htmlspecialchars($_SESSION["nombre"]); ?></span></h1>
    <p class="welcome-text">Selecciona uno de los cursos disponibles para continuar con tu preparación.</p>
  </div>

  <section class="contenedor-tarjetas" id="contenedor-tarjetas">
    <div class="matriz-card-menu">
      <?php 
      if (!isset($cursos) || empty($cursos)) {
        echo "<div style=\"text-align: center; padding: 40px;\">";
        echo "<h3>No hay cursos configurados</h3>";
        echo "<p>Revisa la configuración de cursos.</p>";
        echo "</div>";
      } else {
        $cursosDisponibles = [];
        foreach ($cursos as $codigoCurso => $datoCurso) {
          $numeroCurso = str_replace("c", "", $codigoCurso);
          $rolUsuario = isset($valoresC[$numeroCurso - 1]) ? $valoresC[$numeroCurso - 1] : NULL;
          
          if ($rolUsuario !== NULL) {
            $cursosDisponibles[] = [
              "rol" => $rolUsuario,
              "codigo" => $codigoCurso,
              "datos" => $datoCurso,
              "numero" => $numeroCurso
            ];
          }
        }
        
        usort($cursosDisponibles, function($a, $b) {
          return $a["numero"] - $b["numero"];
        });
        
        if (empty($cursosDisponibles)) {
          echo "<div style=\"text-align: center; padding: 40px;\">";
          echo "<h3>No tienes cursos disponibles</h3>";
          echo "</div>";
        } else {
          foreach ($cursosDisponibles as $cursoInfo): 
            $codigoCurso = $cursoInfo["codigo"];
            $datoCurso = $cursoInfo["datos"];
            $rolUsuario = $cursoInfo["rol"];
      ?>
      
      <div class="caja-card-menu">
        <div class="contenido-card-menu">
          <div class="rol-badge" style="
            display: inline-block;
            padding: 8px 16px;
            border-radius: 25px;
            font-size: 0.9rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            margin-bottom: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            transition: all 0.3s ease;
            <?php 
              $rol = (int)$rolUsuario;
              if ($rol === 0) {
                echo "background: linear-gradient(135deg, #28a745, #20c997); color: white;";
              } elseif ($rol === 1) {
                echo "background: linear-gradient(135deg, #007bff, #0056b3); color: white;";
              } elseif ($rol === 2) {
                echo "background: linear-gradient(135deg, #ffc107, #e0a800); color: #212529;";
              } elseif ($rol === 3) {
                echo "background: linear-gradient(135deg, #6f42c1, #5a2d91); color: white;";
              } elseif ($rol === 4) {
                echo "background: linear-gradient(135deg, #dc3545, #c82333); color: white;";
              } else {
                echo "background: linear-gradient(135deg, #6c757d, #5a6268); color: white;";
              }
            ?>
          ">
            <i class="fas fa-<?php 
              if ($rol === 0) echo "user-graduate";
              elseif ($rol === 1) echo "chalkboard-teacher";
              elseif ($rol === 2) echo "user-check";
              elseif ($rol === 3) echo "eye";
              elseif ($rol === 4) echo "user-shield";
              else echo "user";
            ?>" style="margin-right: 8px;"></i>
            <?php 
              if ($rol === 0) echo "Estudiante";
              elseif ($rol === 1) echo "Profesor";
              elseif ($rol === 2) echo "Revisor";
              elseif ($rol === 3) echo "Observador";
              elseif ($rol === 4) echo "Administrador";
              else echo "Rol " . $rolUsuario;
            ?>
          </div>
          <img src="<?php echo htmlspecialchars($datoCurso["foto"]); ?>" alt="<?php echo htmlspecialchars($datoCurso["nombre_curso"]); ?>" />
          <div class="curso-badge"><?php echo htmlspecialchars($datoCurso["codigo_interno"]); ?> - <?php echo htmlspecialchars($datoCurso["codigo_curso"]); ?></div>
          <h1><?php echo htmlspecialchars($datoCurso["nombre_curso"]); ?></h1>
          <p><strong>Inicio: <?php echo htmlspecialchars($datoCurso["fecha_inicio"]); ?></strong></p>
          
          <?php if ($rolUsuario !== NULL && $datoCurso["estado"] === "Disponible"): ?>
            <a href="./curso.php" class="boton-azul">Ingresar</a>
          <?php else: ?>
            <button class="boton-no-disponible" disabled>No Disponible</button>
          <?php endif; ?>
          
        </div>
      </div>
      
      <?php 
          endforeach;
        }
      }
      ?>
    </div>
  </section>

</body>
</html>';
} else {
    $phpContent = $_POST['phpContent'];
}

try {
    // Guardar el archivo en la carpeta padre (directorio raíz)
    $filePath = '../menu.php';
    
    $bytesWritten = file_put_contents($filePath, $phpContent);
    
    if ($bytesWritten !== false) {
        echo "success: Archivo menu.php guardado exitosamente en " . $filePath . " (bytes: " . $bytesWritten . ")";
    } else {
        throw new Exception("No se pudo escribir el archivo");
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo "Error al guardar el archivo: " . $e->getMessage();
    error_log("Error en guardar_menu_php.php: " . $e->getMessage());
}
?>
