<?php
// Configurar headers para CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: text/plain; charset=utf-8');

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'Method not allowed';
    exit;
}

// Obtener el contenido del archivo
$phpContent = $_POST['phpContent'] ?? '';

if (empty($phpContent)) {
    http_response_code(400);
    echo 'No content provided';
    exit;
}

// Ruta donde guardar el archivo
$filePath = '../session_start.php';

try {
    // Guardar el archivo
    $result = file_put_contents($filePath, $phpContent);
    
    if ($result === false) {
        throw new Exception('No se pudo escribir el archivo');
    }
    
    // Verificar que el archivo se guardó correctamente
    if (!file_exists($filePath)) {
        throw new Exception('El archivo no se creó correctamente');
    }
    
    // Verificar que el contenido se guardó correctamente
    $savedContent = file_get_contents($filePath);
    if ($savedContent !== $phpContent) {
        throw new Exception('El contenido guardado no coincide con el original');
    }
    
    echo 'success: Archivo session_start.php guardado correctamente';
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'error: ' . $e->getMessage();
}
?> 