<?php
/**
 * Lector del archivo lectura_inscripcion_cursos.php
 * Lee el contenido del archivo para extraer la configuración
 */

// Configurar headers para evitar cache
header('Content-Type: text/plain; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Ruta al archivo lectura_inscripcion_cursos.php
$archivo = '../lectura_inscripcion_cursos.php';

// Verificar si el archivo existe
if (!file_exists($archivo)) {
    http_response_code(404);
    echo "<!-- DEBUG: Archivo no encontrado -->\n";
    echo "El archivo lectura_inscripcion_cursos.php no existe en la ubicación esperada.";
    exit;
}

// Leer el contenido del archivo
$contenido = file_get_contents($archivo);

if ($contenido === false) {
    http_response_code(500);
    echo "<!-- DEBUG: Error al leer archivo -->\n";
    echo "Error al leer el archivo lectura_inscripcion_cursos.php";
    exit;
}

// Obtener información del archivo
$tamano = filesize($archivo);
$modificado = date('Y-m-d H:i:s', filemtime($archivo));

// Agregar información de debug
echo "<!-- DEBUG: Archivo encontrado, tamaño: $tamano bytes, modificado: $modificado -->\n";

// Devolver el contenido del archivo
echo $contenido;
?> 